/**
 * @(#)PerfectServlet.java
 *
 * Copyright:	Oathouse.com Ltd (c) 2008. All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Nothing in this notice shall be deemed to grant any rights to
 * trademarks, copyrights, patents, trade secrets or any other intellectual
 * property of the licensor or any contributor except as expressly stated
 * herein. No patent license is granted separate from the Software, for
 * code that you delete from the Software, or for combinations of the
 * Software with other software or hardware.
 */
package com.oathouse.perfectServlet.webapp.controller;

// external classes
import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;

// internal classes
import com.oathouse.perfectServlet.model.*;

public class PerfectServlet extends HttpServlet {
   
    // the simulated application front end
    private Model model;
    
    // an array of possible command objects
    Commands commands[] = Commands.values();
    // the command being executed in each request-reponse cycle
    Commands cmd;
    // the url of the jsp that will generate the response
    String jsp;
     
    /*
     * intialise the servlet
     */
    @Override
    public void init(ServletConfig config)
        throws ServletException {

        super.init(config);

        // intialise the application
        model = new Model();
    }

    /*
     * GET and POST requests are both accepted and call control()
     */
    @Override
    public void doGet(HttpServletRequest req, HttpServletResponse res)
        throws ServletException, IOException {

        control(req, res);
    }

    @Override
    public void doPost(HttpServletRequest req, HttpServletResponse res)
        throws ServletException, IOException {

        control(req, res);
    }

    // final destroy method
    @Override
    public void destroy() {

        model = null;
    }

    /*
     * control()
     *
     * the principle method of the servlet, called by doGet and doPost, providing the Control
     * element of the MVC paradigm
     * 
     * Depending on the web application user's requirments, given by the cmd (short for "command"), 
     * this method calls appropriate private methods with the same name as the cmd (this is a
     * naming convention)
     * 
     * Each private method interacts with the Model (a single class in this application, 
     * but in the real world this would be the front of a full Java application), loads
     * appropriate data into the HttpServletRequest or the HttpSession, and then provides
     * the identity of the jsp that will make the reponse, forming the View
     * 
     */
    private void control(HttpServletRequest req, HttpServletResponse res)
        throws ServletException, IOException {
       
        // get the required command, or set it to an empty string if no command was provided
        String command = req.getParameter(DataNames.cmd.toString())!=null?
            req.getParameter(DataNames.cmd.toString()) : "" ;
        cmd = getCommand(command);
        
        /* 
         * use switch to determine what method to call to action the command
         * 
         * we use switch instead of if...else if on simple strings because:
         * 
         * 1. cleaner code
         * 2. compiler inpects each case and creates a "jump" table that it uses for 
         * selecting the correct path rather than cycling through the if statements each time:
         * - runs must faster!
         * 
         * Note the use of private methods named after the enumeration:
         * this is just a sensible naming convention
         */
        switch(cmd) {
            case actionGetCommand:
                jsp = actionGetCommand(req);
                break;
            case actionPostCommand:
                jsp = actionPostCommand(req);
                break;
            case restartSession:
                jsp = restartSession(req);
                break;
            // if defaultCommand was returned by getCommand()...
            default:
                jsp = JspNames.defaultPage + ".jsp";
        }

        // forward the request and response to the next jsp
        req.getRequestDispatcher(jsp).forward(req, res);
    }

    /*
     * private command methods called by control()
     */
    private String actionGetCommand(HttpServletRequest req) {
        
        // do useful interaction with model here: this is a simluation
        String result = model.getGetResponse();
        
        // add to request
        req.setAttribute(DataNames.result.toString(), result);
        
        // return the url of the jsp that will generate the response
        // don't need to pass req - it's already passed by reference
        return(JspNames.finishedGet + ".jsp");
    }
    
    private String actionPostCommand(HttpServletRequest req) {
        
        // do useful interaction with model here: this is a simluation
        String result = model.getPostResponse();
        
        // add to request
        req.setAttribute(DataNames.result.toString(), result);
        
        // add something to session
        HttpSession session = req.getSession();
        String something = "A string about something";
        
        session.setAttribute(DataNames.something.toString(), something);
        
        // return the url of the jsp that will generate the response
        // don't need to pass req - it's already passed by reference
        return(JspNames.finishedPost + ".jsp");
    }
    
    private String restartSession(HttpServletRequest req) {
        
        HttpSession session = req.getSession();
        session.invalidate();
        
        return(JspNames.index + ".jsp");
    }
    
    
    /*
     * private methods used by the servlet
     */
    // fetch the appropriate Commands object given a string to match against
    private Commands getCommand(String cmd) {
        
        for(Commands command : commands) {
            
            if(command.toString().equals(cmd)) {
                return(command);
            }
        }
        // not a "proper" command
        return(Commands.defaultCommand);
    }
    
    

}